#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>
#include <ctype.h>
#include <stdarg.h>

#include "a.h"

#include "ParserIO.h"
#include "Parser.h"

static
char applesoft_tokens[][8]=
{
	"END", "FOR", "NEXT", "DATA", "INPUT", "DEL", "DIM", "READ",
	"GR", "TEXT", "PR#", "IN#", "CALL", "PLOT", "HLIN", "VLIN",

	"HGR2", "HGR", "HCOLOR=", "HPLOT", "DRAW", "XDRAW", "HTAB", "HOME",
	"ROT=", "SCALE=", "SHLOAD", "TRACE", "NOTRACE", "NORMAL", "INVERSE", "FLASH",

	"COLOR=", "POP", "VTAB", "HIMEM:", "LOMEM:", "ONERR", "RESUME", "RECALL",
	"STORE", "SPEED=", "LET", "GOTO", "RUN", "IF", "RESTORE", "&",

	"GOSUB", "RETURN", "REM", "STOP", "ON", "WAIT", "LOAD", "SAVE",
	"DEF", "POKE", "PRINT", "CONT", "LIST", "CLEAR", "GET", "NEW",

	"TAB(", "TO", "FN", "SPC(", "THEN", "AT", "NOT", "STEP",
	"+", "-", "*", "/", "^", "AND", "OR", ">",
	"=", "<", "SGN", "INT", "ABS", "USR", "FRE", "SCRN(",
	"PDL", "POS", "SQR", "RND", "LOG", "EXP", "COS", "SIN",
	"TAN", "ATN", "PEEK", "LEN", "STR$", "VAL", "ASC", "CHR$",
	"LEFT$", "RIGHT$", "MID$", "", "", "", "", "",
	"", "", "", "", "", "", "", "",
	"", "", "", "", "", "(", "(", "("
};


Parser::Parser()
:m_pclParserIO(NULL)
,m_fil(NULL)
,m_linebase(NULL)
,m_current_line(NULL)
,m_next_line(NULL)
,m_onerror(NULL)
,m_nextbase(NULL)
,m_database(NULL)
,m_current_data(NULL)
,m_subbase(NULL)
,m_funcbase(NULL)
,m_placeholder(NULL)
,m_running(0)
,m_the_ptr(0)
,m_file_read(0)
,m_file_write(0)
,m_tab_pos(0)
,m_dataptr(0)
,m_variablebase(NULL)
,m_openbase(NULL)
,m_obufptr(0)
,m_load_ok(1)
{
	*m_run_program = 0;
	*m_the_str = 0;
	*m_programname = 0;
	*m_program_cwd = 0;
	*m_obuf = 0;
}


Parser::Parser(char *program)
:m_pclParserIO(NULL)
,m_tab_pos(0)
,m_obufptr(0)
{
	strcpy(m_run_program, program);
}


Parser::~Parser()
{
	finish();
}


void Parser::strupr(char *s)
{
	int i;

	for (i = 0; i < (int)strlen(s); i++)
		if (s[i] >= 'a' && s[i] <= 'z')
			s[i] -= 32;
}


void Parser::addlist(void *_base,void *_item)
{
	LINE **base = (LINE **)_base;
	LINE *item = (LINE *)_item;
	LINE *q;

	item -> next = NULL;
	q = *base;
	if (!q)
		*base = item;
	else
	{
		while (q -> next)
			q = q -> next;
		q -> next = item;
	}
}

void Parser::removelist(void *_base,void *_item)
{
	LINE **base = (LINE **)_base;
	LINE *item = (LINE *)_item;
	LINE *q,*prev = NULL;

	if (item == *base)
		*base = item -> next;
	else
	{
		for (q = *base; q; q = q -> next)
			if (item == q)
			{
				prev -> next = item -> next;
				break;
			}
			else
				prev = q;
	}
}


void Parser::verify_filename(char *s)
{
	int i;

	if (s)
	{
		for (i = 0; i < (int)strlen(s); i++)
		{
			switch (s[i])
			{
			case '/':
				s[i] = '_';
			}
		}
	}
}


void Parser::read_file(char *filename)
{
	FILE *fil;
	LINE *ln;
	int i,x;
	short size;
	short q;	// quote
	short ifc;
	short data;
	short rem;
	short ok = 1;
	short uc = 0;
	unsigned char c_length;
	unsigned char c_eight;
	unsigned char c_line1;
	unsigned char c_line2;
	unsigned char c;
	char slask[1024];
	char filename_uc[100];

	if (!strcasecmp(filename,"basefix"))
		return;

	verify_filename( filename );
	strcpy(filename_uc, filename);
	strupr(filename_uc);
	m_load_ok = 0;

	if (*filename_uc < 'A' || *filename_uc > 'Z')
	{
fprintf(stderr,"Illegal filename '%s'\n",filename);
		return;
	}

	strcpy(m_programname,filename);
	getcwd(m_program_cwd,200);
fprintf(stderr,"*** Current program: '%s' ***\n",m_programname);
fprintf(stderr,"getcwd() == '%s'\n",m_program_cwd);

	sprintf(slask,"%s.txt",filename);
	fil = fopen(slask,"rt");
	if (!fil)
	{
		sprintf(slask,"%s.txt",filename_uc);
		fil = fopen(slask,"rt");
		if (fil)
			uc++;
	}
	if (!fil)
	{
		sprintf(slask,"../ea.master/%s.txt",filename);
		fil = fopen(slask,"rt");
		if (!fil)
		{
			sprintf(slask,"../ea.master/%s.txt",filename_uc);
			fil = fopen(slask,"rt");
			if (fil)
				uc++;
		}
		if (fil)
		{
			fclose(fil);
			chdir("../ea.master");
			sprintf(slask,"%s.txt",filename);
			fil = fopen(slask,"rt");
			if (!fil)
			{
				sprintf(slask,"%s.txt",filename_uc);
				fil = fopen(slask,"rt");
				if (fil)
					uc++;
			}
		}
	}
	if (uc)
		strcpy(m_programname,filename_uc);
	if (fil) // text file open ok
	{
fprintf(stderr," ** loading text file '%s'\n",slask);
		fgets(slask,1024,fil);
		while (!feof(fil))
		{
			slask[strlen(slask) - 1] = 0;
			i = 0;
			while (slask[i] && (slask[i] == ' ' || slask[i] == 9))
				i++;

			ln = new LINE;
			if (isdigit(slask[i]))
			{
				x = i;
				while (isdigit(slask[i]))
					i++;
				slask[i++] = 0;
				ln -> line = atoi(slask + x);
				while (slask[i] && (slask[i] == ' ' || slask[i] == 9))
					i++;
			}
			else
			{
				ln -> line = -1;
			}
			ln -> the_str = new char[strlen(slask + i) + 1];
			strcpy(ln -> the_str,slask + i);
			addlist(&m_linebase,ln);

			if (!strncasecmp(ln -> the_str,"data ",5))
			{
				strcpy(m_the_str,ln -> the_str);
				m_the_ptr = 0;
				m_current_line = ln;
				if (yyparse(this))
				{
					m_next_line = NULL;
					ok = 0;
				}
			}

			fgets(slask,1024,fil);
		}
		fclose(fil);
		m_load_ok = ok;
	}
	else
	{
		fil = fopen(filename,"rb");
		if (!fil)
		{
			fil = fopen(filename_uc,"rb");
			if (fil)
				uc++;
		}
		if (!fil)
		{
			sprintf(slask,"../ea.master/%s",filename);
			fil = fopen(slask,"rb");
			if (!fil)
			{
				sprintf(slask,"../ea.master/%s",filename_uc);
				fil = fopen(slask,"rb");
				if (fil)
					uc++;
			}
			if (fil)
			{
				fclose(fil);
				chdir("../ea.master");	// magic
				fil = fopen(filename,"rb");
				if (!fil)
				{
					fil = fopen(filename_uc,"rb");
					if (fil)
						uc++;
				}
			}
		}
		if (uc)
			strcpy(m_programname,filename_uc);
		if (fil)
		{
fprintf(stderr," ** loading binary file '%s'\n",m_programname);
			// 2 bytes size
			fread(&size,1,2,fil);
fprintf(stderr," size %d\n",size);
			while (!feof(fil))
			{
				// 1 byte length, 1 byte == 8?
				fread(&c_length,1,1,fil);
				fread(&c_eight,1,1,fil);
				if (!c_eight)
				{
					break;
				}
				// 2 bytes line number
				fread(&c_line1,1,1,fil);
				fread(&c_line2,1,1,fil);
				ln = new LINE; //(LINE *)malloc(sizeof(LINE));
				ln -> line = (((int)c_line2) << 8) + c_line1;
				*slask = 0;
				q = 0;
				ifc = 0;
				data = 0;
				rem = 0;

				// line data
				fread(&c,1,1,fil);
				while (c && !feof(fil))
				{
					if (c >= 0x80)
					{
						if (c == 0x83) // Data
							data = 1;
						if (c == 0xad) // If
							ifc = 1;
						if (c == 0xb2) // Rem
							rem = 1;
						if (ifc && *slask && (c == 0xc4 || c == 0xab)) // Then / Goto
						{
							ln -> the_str = new char[strlen(slask) + 1]; //(char *)malloc(strlen(slask) + 1);
							strcpy(ln -> the_str,slask);
							if (*slask)
							{
								addlist(&m_linebase,ln);
							} else
								delete ln; //free(ln);
							if (data && *slask)
							{
								strcpy(m_the_str,slask);
								m_the_ptr = 0;
								m_current_line = ln;
								if (yyparse(this))
								{
									m_next_line = NULL;
									ok = 0;
								}
							}

							ln = new LINE; //(LINE *)malloc(sizeof(LINE));
							ln -> line = -1;
							*slask = 0;
							q = 0;
							ifc = 0;
							data = 0;
						}
						if (strlen(slask) + strlen(applesoft_tokens[c - 0x80]) < 1023)
							sprintf(slask + strlen(slask)," %s ",applesoft_tokens[c - 0x80]);
					}
					else
					if (c == ':' && !q && !rem)
					{
						ln -> the_str = new char[strlen(slask) + 1]; //(char *)malloc(strlen(slask) + 1);
						strcpy(ln -> the_str,slask);
						if (*slask)
						{
							addlist(&m_linebase,ln);
						} else
							delete ln; //free(ln);
						if (data && *slask)
						{
							strcpy(m_the_str,slask);
							m_the_ptr = 0;
							m_current_line = ln;
							if (yyparse(this))
							{
								m_next_line = NULL;
								ok = 0;
							}
						}

						ln = new LINE; //(LINE *)malloc(sizeof(LINE));
						ln -> line = -1;
						*slask = 0;
						q = 0;
						ifc = 0;
						data = 0;
					}
					else
					{
						if (rem && (c == 13 || c == 10))
							c = '_';
						if (strlen(slask) + 1 < 1023)
							sprintf(slask + strlen(slask),"%c",c);
						if (c == 34)
							q = !q;
					}

					fread(&c,1,1,fil);
				} // while (c && !feof(fil))

				ln -> the_str = new char[strlen(slask) + 1]; //(char *)malloc(strlen(slask) + 1);
				strcpy(ln -> the_str,slask);
				if (*slask)
				{
					addlist(&m_linebase,ln);
				} else
					delete ln; //free(ln);
				if (data && *slask)
				{
					strcpy(m_the_str,slask);
					m_the_ptr = 0;
					m_current_line = ln;
					if (yyparse(this))
					{
						m_next_line = NULL;
						ok = 0;
					}
				}
			} // while (!feof(fil))
			fclose(fil);
			m_load_ok = ok;

			if (ok)
				write_file();
		}
		else
		{
			fprintf(stderr,"Couldn't open '%s'...\n",filename);
//			exit(-1);
		}
	}
}

void Parser::write_file()
{
	FILE *fil;
	LINE *ln;
	char slask[200];

	if (!*m_programname)
		return;

	if (!m_load_ok)
		return;

	sprintf(slask,"%s.txt",m_programname);
	if ((fil = fopen(slask,"wt")) != NULL)
	{
		for (ln = m_linebase; ln; ln = ln -> next)
		{
			if (ln -> line > -1)
				fprintf(fil,"%5d %s\n",ln -> line,ln -> the_str);
			else
				fprintf(fil,"      %s\n",ln -> the_str);
		}
		fclose(fil);
	}
}

VARIABLE *Parser::reg_variable(char *name,EXPRLIST *p)
{
	VARIABLE *v;
	int i;
	char type[2];

	if (*name != '$') // not a function (def fn)
	{
		switch (name[strlen(name) - 1])
		{
		case '$':
			strcpy(type,"$");
			name[strlen(name) - 1] = 0;
			break;
		case '%':
			strcpy(type,"%");
			name[strlen(name) - 1] = 0;
			break;
		default:
			*type = 0;
		}
		name[2] = 0;
		strcat(name,type);
	}

	if (p)
	{
		strcat(name,"(");
		for (i = 0; i < p -> qty; i++)
		{
			if (i)
				strcat(name,",");
			sprintf(name + strlen(name),"%d",(int)(p -> values[i] + 0.01));
		}
		strcat(name,")");
	}

	for (v = m_variablebase; v; v = v -> next)
	{
		if (!strcmp(v -> name,name))
			break;
	}
	if (!v)
	{
		v = new VARIABLE; //(VARIABLE *)malloc(sizeof(VARIABLE));
		if (!v)
		{
			fprintf(stderr,"malloc failed\n");
			exit(-1);
		}
		strcpy(v -> name,name);
		v -> ivalue = 0;
		v -> value = v -> fnvalue = 0;
		*v -> svalue = 0;
		v -> next = m_variablebase;
		m_variablebase = v;
	}
	return v;
}


void Parser::text_output(char *s)
{
	OPEN *o;
	char *cmd;
	char *arg;
	char *option;
	long offset;
	int i;
	short cmnum;
	short option_s;
	short option_d;
	short option_l;
	short option_r;
	char slask[1024];

	if (*s == 4)	// CHR$(4) - dos command
	{
		if (s[strlen(s) - 1] == '\n');
			s[strlen(s) - 1] = 0;
		m_file_read = 0;
		m_file_write = 0;
		m_fil = NULL;
		cmd = strtok(s + 1," ");
		if (!cmd)
		{
#ifdef DEBUG
			fprintf(stderr," * Empty CHR$(4)\n");
#endif
			return;
		}
		arg = strtok(NULL,",");
#ifdef DEBUG
fprintf(stderr," * file command '%s' argument '%s'\n",cmd,arg);
#endif
		if (!strcmp(cmd,"RUN"))
			cmnum = 1;
		else
		if (!strcmp(cmd,"OPEN"))
			cmnum = 2;
		else
		if (!strcmp(cmd,"CLOSE"))
			cmnum = 3;
		else
		if (!strcmp(cmd,"READ"))
			cmnum = 4;
		else
		if (!strcmp(cmd,"WRITE"))
			cmnum = 5;
		else
		if (!strcmp(cmd,"DELETE"))
			cmnum = 6;
		else
		{
			fprintf(stderr,"##############################################\n");
			fprintf(stderr,"#### implement dos command\n");
			fprintf(stderr,"####  cmd '%s' arg '%s'\n",cmd,arg);
			cmnum = 0;
		}

		option = strtok(NULL,",");
		option_s = -1;
		option_d = -1;
		option_l = -1;
		option_r = -1;
		while (option)
		{
#ifdef DEBUG
fprintf(stderr,"   option '%s'\n",option);
#endif
			if (!cmnum)
			{
				fprintf(stderr,"####  cmd '%s' arg '%s' option '%s'\n",cmd,arg,option);
			}
			else
			switch (*option)
			{
			case 'S':
				option_s = atoi(option + 1);
				break;
			case 'D':
				option_d = atoi(option + 1);
				break;
			case 'L':
				option_l = atoi(option + 1);
				break;
			case 'R':
				option_r = atoi(option + 1);
				break;
			default:
				fprintf(stderr,"####  cmd '%s' arg '%s' option '%s'\n",cmd,arg,option);
				fprintf(stderr,"##############################################\n");
			}
			option = strtok(NULL,",");
		} // while (option)

		if (!cmnum)
		{
			fprintf(stderr,"##############################################\n");
		}

		if (!m_running)
			return;

		switch (cmnum)
		{
		case 1: // run
			verify_filename( arg );
			fprintf(stderr," * RUN '%s'\n",arg);
			strcpy(m_run_program,arg);
			m_next_line = NULL;
			break;
		case 2: // open ,S ,D ,L
			verify_filename( arg );
			for (o = m_openbase; o; o = o -> next)
				if (!strcmp(o -> name,arg))
					break;
			if (o)
			{
//				fprintf(stderr," *** FILE already OPEN\n");
			}
			else
			{
				o = new OPEN; //(OPEN *)malloc(sizeof(OPEN));
				o -> fil = fopen(arg,"r+b");
				if (!o -> fil)
					o -> fil = fopen(arg,"w+b");
				if (!o -> fil)
				{
					fprintf(stderr," *** OPEN '%s' failed\n",arg);
					m_next_line = m_onerror;
					delete o; //free(o);
				}
				else
				{
					strcpy(o -> name,arg);
					stat(arg,&o -> file_stat);
					o -> option_s = option_s;
					o -> option_d = option_d;
					o -> option_l = option_l;
					o -> option_r = 0;
					addlist(&m_openbase,o);
				}
			}
			break;
		case 3: // close
			if (arg)
			{
				verify_filename( arg );
				for (o = m_openbase; o; o = o -> next)
					if (!strcmp(o -> name,arg))
						break;
				if (!o)
					fprintf(stderr," *** FILE not OPEN (CLOSE)\n");
				else
				{
					fclose(o -> fil);
					removelist(&m_openbase,o);
					delete o; //free(o);
				}
			}
			else
			{
				while (m_openbase)
				{
					o = m_openbase;
					fclose(o -> fil);
					removelist(&m_openbase,o);
					delete o; //free(o);
				}
			}
			break;
		case 4: // read ,R
			verify_filename( arg );
			for (o = m_openbase; o; o = o -> next)
				if (!strcmp(o -> name,arg))
					break;
			if (!o)
				fprintf(stderr," *** FILE not OPEN (READ)\n");
			else
			{
				if (option_r > -1)
				{
					o -> option_r = option_r;
					offset = (long)o -> option_l * (long)o -> option_r;
					if (offset > o -> file_stat.st_size)
						m_next_line = m_onerror;
//					fprintf(stderr," * READ '%s' ,L%d ,R%d  Offset 0x%04lx\n",arg,o -> option_l,o -> option_r,offset);
					if (fseek(o -> fil,offset,SEEK_SET))
						m_next_line = m_onerror;
				}
				m_file_read = 1;
				m_fil = o -> fil;
			}
			break;
		case 5: // write ,R
			verify_filename( arg );
			for (o = m_openbase; o; o = o -> next)
				if (!strcmp(o -> name,arg))
					break;
			if (!o)
				fprintf(stderr," *** FILE not OPEN (WRITE)\n");
			else
			{
#ifdef DEBUG
fprintf(stderr," * Write to file '%s'\n",o -> name);
#endif
				if (option_r > -1)
				{
					o -> option_r = option_r;
					offset = (long)o -> option_l * (long)o -> option_r;
#ifdef DEBUG
					fprintf(stderr," * WRITE '%s' ,L%d ,R%d  Offset 0x%04lx\n",arg,o -> option_l,o -> option_r,offset);
#endif
					if (fseek(o -> fil,offset,SEEK_SET))
						m_next_line = m_onerror;
				}
				m_file_write = 1;
				m_fil = o -> fil;
#ifdef DEBUG
fprintf(stderr," * ...\n");
#endif
			}
			break;
		case 6: // delete
			verify_filename( arg );
			unlink(arg);
			break;

		default:
			break;
		} // switch (cmnum)

	}
	else
	{
		if (m_fil && m_file_write)
		{
			if (s[strlen(s) - 1] == 0x0a)
				s[strlen(s) - 1] = 0x8d;
			fwrite(s,strlen(s),1,m_fil);
		}
		else
		if (m_pclParserIO)	// callbacks class
		{
			int l = strlen(s);

			if (m_obufptr + l >= OBUFSIZE - 1)
			{
				flush_obuf();
			}
			memmove(m_obuf + m_obufptr, s, l);
			m_obufptr += l;
		}
		else	// stdout
		{
			fprintf(stderr,"#### USE PARSER IO FUNCTION ####\n");
			exit(-1);

			i = 0;
			while (s[i])
			{
				if (strlen(s + i) > 40)
				{
					strncpy(slask,s + i,40);
					slask[40] = 0;
					printf("%s\n",slask);
					i += 40;
				}
				else
				{
					printf("%s",s + i);
					i += strlen(s + i);
				}
				fflush(stdout);
			}
		}
	}
}

void Parser::pprintf(char *format, ...)
{
	va_list vl;
	char buf[1024];

	va_start(vl, format);
	vsprintf(buf, format, vl);
	va_end(vl);

	text_output( buf );
}


void Parser::file_input(char *s,int l)
{
	int i = 0;
	short q = 0;
	unsigned char c;

	if (m_fil)
		fread(&c,1,1,m_fil);
	while (m_fil && !feof(m_fil) && c != 0x8d && (q || (c & 0x7f) != ',') && c)
	{
		if (i >= l - 1)
		{
			fprintf(stderr," ********* BUFFER OVERFLOW ********\n");
			s[l - 1] = 0;
			fprintf(stderr,"%s\n",s);
			exit(-1);
		}
		s[i++] = c & 0x7f;
		if ( (c & 0x7f) == 34)
			q = !q;
#ifdef DEBUG
fprintf(stderr,"%c",c & 0x7f);
#endif
		fread(&c,1,1,m_fil);
	}
	s[i] = 0;
	if (*s == 34 && s[strlen(s) - 1] == 34)
	{
		memmove(s,s + 1,strlen(s) + 1);
		s[strlen(s) - 1] = 0;
	}
#ifdef DEBUG
fprintf(stderr,"\n");
#endif
}


#define DC (m_current_data?m_current_data->data[m_dataptr]:0)

void Parser::get_data(char *s)
{
	int x = 0;

	while (DC == ' ' || DC == 9)
		m_dataptr++;
	if (!DC)
	{
		m_current_data = m_current_data ? m_current_data -> next : NULL;
		m_dataptr = 0;
		while (DC == ' ' || DC == 9)
			m_dataptr++;
	}
	if (DC)
	{
		while (DC && DC != ',')
		{
			s[x++] = DC;
			m_dataptr++;
		}
		if (DC == ',')
			m_dataptr++;
	}
	s[x] = 0;
}

void Parser::read_data(VARLIST *vl)
{
	int i;

	for (i = 0; i < vl -> qty; i++)
	{
		get_data(vl -> var[i] -> svalue);
		vl -> var[i] -> value = atof(vl -> var[i] -> svalue);
#ifdef DEBUGDATA
fprintf(stderr,"Read Data;  %s = '%s'\n",vl -> var[i] -> name,vl -> var[i] -> svalue);
#endif
	}
}

void Parser::SetParserIO(ParserIO *pclIO)
{
	m_pclParserIO = pclIO;
	m_pclParserIO -> m_more = 0;
}

void Parser::flush_obuf(void)
{
	if (m_pclParserIO)
	{
		m_pclParserIO -> write_text(m_obuf, m_obufptr);
		m_obufptr = 0;
	}
}

int Parser::inputstring(char *s,int l)
{
	int ll = l;
	int i;

	if (m_pclParserIO)
	{
		flush_obuf();
		if (m_pclParserIO -> read_text(s,&ll) == -1)
		{
			perror("read_text() failed");
			return -1;
		}
		s[ll] = 0;
	}
	else
	{
		fprintf(stderr,"#### USE PARSER IO FUNCTION ####\n");
		exit(-1);

//		gets(s);
		ll = read(0, s, l);
		s[ll] = 0;
		while (strlen(s) && (s[strlen(s) - 1] == 13 || s[strlen(s) - 1] == 10))
		{
			s[strlen(s) - 1] = 0;
		}
		if (*s == '.')
		{
			if (chdir( s ) == -1)
			{
				perror("chdir() failed");
				fprintf(stderr," ('%s') length %d\n",s,strlen(s));
			}
		}
		for (i = 0; i < ll; i++)
			if (s[i] >= 'a' && s[i] <= 'z')
				s[i] -= 32;
	}
	return ll;
}

void Parser::save_variables()
{
	FILE *fil;
	VARIABLE *v;
	char slask[200];

	sprintf(slask,"%s/%s.lastrun",m_program_cwd,m_programname);
	if ((fil = fopen(slask,"wb")) != NULL)
	{
		for (v = m_variablebase; v; v = v -> next)
		{
			fwrite(v,1,sizeof(VARIABLE),fil);
		}
		fclose(fil);
	}
}

void Parser::load_variables()
{
	FILE *fil;
	VARIABLE *v;
	char slask[200];

	sprintf(slask,"%s.lastrun",m_programname);
	if ((fil = fopen(slask,"rb")) != NULL)
	{
		v = new VARIABLE;
		fread(v,1,sizeof(VARIABLE),fil);
		while (!feof(fil))
		{
			addlist(&m_variablebase,v);

			v = new VARIABLE;
			fread(v,1,sizeof(VARIABLE),fil);
		}
		delete v;
		fclose(fil);
	}
}

VARIABLE *Parser::get_variable(char *name)
{
	VARIABLE *v;
	
	for (v = m_variablebase; v; v = v -> next)
		if (!strcmp(v -> name,name))
			break;
	return v;
}

int Parser::peek(int addr)
{
	switch (addr)
	{
	default:
		return 0; //m_mem[addr];
	}
}

void Parser::poke(int a,int value)
{
	int addr = a;

	if (addr < 0)
		addr += 65536;
//	m_mem[addr] = value;
#ifdef DEBUGMEM
fprintf(stderr,"poke(%d,%d)\n",addr,value);
#endif
}


void Parser::execute()
{
	m_current_line = m_linebase;
	while (m_current_line)
	{
		m_next_line = m_current_line -> next;
		strcpy(m_the_str,m_current_line -> the_str);
		m_the_ptr = 0;
#ifdef DEBUGEXPR
fprintf(stderr," %4d %s\n",m_current_line -> line,m_current_line -> the_str);
#endif
		m_placeholder = NULL;
		if (yyparse(this))
			m_next_line = NULL;
		if (m_placeholder)
			m_placeholder -> value = m_placeholder -> fnvalue;
		m_current_line = m_next_line;
	}
}

void Parser::finish()
{
	LINE *ln;
	LINE *tmpln;
	VARIABLE *v;
	VARIABLE *tmpv;
	NEXT *nx;
	NEXT *tmpnx;
	SUB *sub;
	SUB *tmpsub;
	OPEN *o;
	OPEN *tmpo;
	DATA *d;
	DATA *tmpd;
	FUNC *f;
	FUNC *tmpf;

	*m_programname = 0;
	m_current_line = NULL;
	m_load_ok = 1;
	for (ln = m_linebase; ln; ln = tmpln)
	{
		tmpln = ln -> next;
		delete ln -> the_str; //free(ln -> the_str);
		delete ln; //free(ln);
	}
	m_linebase = NULL;
	for (v = m_variablebase; v; v = tmpv)
	{
		tmpv = v -> next;
		delete v; //free(v);
	}
	m_variablebase = NULL;
	for (nx = m_nextbase; nx; nx = tmpnx)
	{
		tmpnx = nx -> next;
		delete nx; //free(nx);
	}
	m_nextbase = NULL;
	for (sub = m_subbase; sub; sub = tmpsub)
	{
		tmpsub = sub -> next;
		delete sub; //free(sub);
	}
	m_subbase = NULL;
	for (o = m_openbase; o; o = tmpo)
	{
		tmpo = o -> next;
		fclose(o -> fil);
		delete o; //free(o);
	}
	m_openbase = NULL;
	for (d = m_database; d; d = tmpd)
	{
		tmpd = d -> next;
		delete d -> data; //free(d -> data);
		delete d; //free(d);
	}
	m_database = NULL;
	for (f = m_funcbase; f; f = tmpf)
	{
		tmpf = f -> next;
		delete f; //free(f);
	}
	m_funcbase = NULL;
}


void Parser::cmd(char *in)
{
	struct stat st;
	FILE *fil;
	LINE *ln;
	LINE *ln2;
	LINE *newln;
	char *cmd;
	char *arg;
	char *option;
	char *ptr;
	int cmnum;
	int i;
	int x = 0;
	int quit;
	int dir;
	char c;
	char slask[512];
	char s[1024];
	char s2[1024];
	char tok[20];
	char repl[200];
	char with[200];

	strcpy(s, in);

	while (s[strlen(s) - 1] == 13 || s[strlen(s) - 1] == 10)
		s[strlen(s) - 1] = 0;

	cmd = strtok(s," ");
	if (!cmd)
	{
#ifdef DEBUG
		fprintf(stderr," * Empty CHR$(4)\n");
#endif
		return;
	}
	arg = strtok(NULL,",");
#ifdef DEBUG
fprintf(stderr," * file command '%s' argument '%s'\n",cmd,arg);
#endif
	if (!strcasecmp(cmd,"LOAD"))
		cmnum = 1;
	else
	if (!strcasecmp(cmd,"SAVE"))
		cmnum = 2;
	else
	if (!strcasecmp(cmd,"RUN"))
		cmnum = 3;
	else
	if (!strcasecmp(cmd,"LIST"))
		cmnum = 4;
	else
	if (!strcasecmp(cmd,"NEW"))
		cmnum = 5;
	else
	if (!strncasecmp(cmd,"cat",3))
		cmnum = 6;
	else
	if (!strcasecmp(cmd,"edit"))
		cmnum = 7;
	else
	if (!strcasecmp(cmd,"info"))
		cmnum = 8;
	else
	if (!strcasecmp(cmd,"help"))
		cmnum = 9;
	else
	if (!strcasecmp(cmd,"disks"))
		cmnum = 10;
	else
	if (!strcasecmp(cmd,"cd"))
		cmnum = 11;
	else
	if (!strcasecmp(cmd,"type"))
		cmnum = 12;
	else
	if (!strcasecmp(cmd,"dump"))
		cmnum = 13;
	else
	{
//		fprintf(stderr,"##############################################\n");
		fprintf(stderr,"#### implement dos command\n");
		fprintf(stderr,"####  cmd '%s' arg '%s'\n",cmd,arg);
		cmnum = 0;
	}

	option = strtok(NULL,",");
	while (option)
	{
		switch (*option)
		{
		default:
			fprintf(stderr,"####  cmd '%s' arg '%s' option '%s'\n",cmd,arg,option);
//			fprintf(stderr,"##############################################\n");
		}
		option = strtok(NULL,",");
	} // while (option)

	switch (cmnum)
	{
	case 1: // load
		if (!arg)
		{
			pprintf("LOAD what?\n");
			break;
		}
		finish();
		m_running = 0;
		read_file( arg );
		if (!m_load_ok)
		{
			strupr( arg );
			finish();
			m_running = 0;
			read_file( arg );
		}
		if (!m_load_ok)
		{
			finish();
		}
		break;
	case 2: // save
		if (arg)
		{
			strupr( arg );
			strcpy(m_programname, arg);
			verify_filename(m_programname);
		}
		if (*m_programname >= 'A' && *m_programname <= 'Z' && m_load_ok)
		{
			write_file();
		}
		break;
	case 3: // run
		if (arg)
		{
			finish();
			m_running = 0;
			read_file( arg );
			if (!m_load_ok)
			{
				finish();
				m_running = 0;
				strupr( arg );
				read_file( arg );
			}
		}
		if (!m_load_ok)
		{
			finish();
		}
		do
		{
// make optional
//			this -> load_variables();

			m_current_data = m_database;
			m_dataptr = 0;
			m_onerror = NULL;
			m_fil = NULL;

			*m_run_program = 0;

			m_running = 1;

			this -> execute();
			this -> flush_obuf();
// make optional
//			this -> save_variables();

			if (*m_run_program)
			{
				this -> finish();
				m_running = 0;
				read_file( m_run_program );
			}

		} while (*m_run_program);
		break;
	case 4: // list
		m_running = 0;
		i = 0;
		for (ln = m_linebase; ln; ln = ln -> next)
		{
			m_current_line = ln;
			// generate source listing
			if (ln -> line > -1)
				pprintf(" %5d",ln -> line);
			else
				pprintf("      ");
			pprintf(" %s\n",ln -> the_str);

			strcpy(m_the_str,ln -> the_str);
			m_the_ptr = 0;
			if (yyparse( this ))
			{
				break;
			}
			if (m_pclParserIO -> m_more && i++ > 20 && ln -> next)
			{
				pprintf("[More]");
				inputstring(slask,200);
				if (*slask == 'q' || *slask == 'Q')
					break;
				i = 0;
			}
		}
		break;
	case 5: // new
		finish();
		break;
	case 6: // cat(alog)
		if ((fil = popen("ls","r")) != NULL)
		{
			fgets(slask,200,fil);
			*s2 = 0;
			while (!feof(fil))
			{
				slask[strlen(slask) - 1] = 0;
				x = 0;
				for (i = 0; i < (int)strlen(slask); i++)
					if (slask[i] >= 'a' && slask[i] <= 'z')
						x++;
				if (!strcmp(slask,s2))
					x++;
				if (!x)
				{
					stat(slask, &st);
					i = 0;
					if (st.st_mode & 0100) // owner executable
						i |= 1;
					if (st.st_mode & 010) // group executable
						i |= 2;
					if (st.st_mode & 01) // all executable
						i |= 4;
// bits 0 .. 7 = tiabsrab
					pprintf(" %c ","TIABSRAB"[i]);
					pprintf("%4d  ",st.st_size / 1024);
					pprintf("%s\n",slask);
				}
				strcpy(s2,slask);
				fgets(slask,200,fil);
			}
			pclose(fil);
		}
		break;
	case 7: // edit (line)
		if (!arg)
		{
			ln = m_linebase;
		}
		else
		{
			i = atoi(arg);
			for (ln = m_linebase; ln; ln = ln -> next)
				if (ln -> line == i)
					break;
			if (!ln)
			{
				pprintf("Line %d does not exist\n",i);
				break;
			}
		}
		quit = 0;
		dir = 1;	// riktning ner
		while (!quit)
		{
			if (!ln)
				pprintf("***** End of file.\n");
			else
			{
				if (ln -> line > -1)
					pprintf("%5d %s\n",ln -> line,ln -> the_str);
				else
					pprintf("      %s\n",ln -> the_str);
			}
//			pprintf("ED(%c)> ",(dir == 1) ? '>' : '<');
			pprintf("ED> ");
			inputstring(slask, 200);
			switch (*slask)
			{
			case '<': // upp
				dir = -1;
				if (ln == m_linebase)
					pprintf("Already at top.\n");
				else
				{
					for (ln2 = m_linebase; ln2; ln2 = ln2 -> next)
						if (ln2 -> next == ln)
							break;
					ln = ln2;
				}
				break;
			case '>': // ner
				dir = 1;
				if (!ln)
					pprintf("Already at bottom.\n");
				else
					ln = ln -> next;
				break;
			case 's': // byt ut
			case 'S':
				if (!ln)
					break;
				sprintf(tok,"%c",slask[1]);

				ptr = strtok(slask + 2,tok);
				if (!ptr)
					break;
				strcpy(repl, ptr); // replace this

				ptr = strtok(NULL,tok);
				if (!ptr)
					break;
				strcpy(with, ptr); // with this

				strcpy(s2, ln -> the_str);
				ptr = strstr(s2, repl);
				if (!ptr)
				{
					pprintf("'%s' not found in line\n",repl);
					break;
				}
				*ptr = 0;
				{
					char temp[1024];
					sprintf(temp,"%s%s%s",
						s2,
						with,
						ptr + strlen(repl));
					if (strlen(temp) > strlen(ln -> the_str))
					{
						delete ln -> the_str;
						ln -> the_str = new char[strlen(temp) + 1];
					}
					strcpy(ln -> the_str,temp);
				}
				break;
			case 'd': // ta bort
			case 'D':
				if (!ln)
					break;
				if (ln -> next -> line == -1)
					ln -> next -> line = ln -> line;
				if (ln == m_linebase)
				{
					m_linebase = ln -> next;
					delete ln -> the_str;
					delete ln;
					ln = m_linebase;
				}
				else
				{
					for (ln2 = m_linebase; ln2; ln2 = ln2 -> next)
						if (ln2 -> next == ln)
							break;
					if (ln2)
					{
						ln2 -> next = ln -> next;
						delete ln -> the_str;
						delete ln;
						ln = ln2 -> next;
					}
				}
				break;
			case 'i': // insert
			case 'I':
				if (ln == m_linebase)
					ln2 = NULL;
				else
					for (ln2 = m_linebase; ln2; ln2 = ln2 -> next)
						if (ln2 -> next == ln)
							break;
				while (1)
				{
					pprintf("     .");
					inputstring(slask,500);
					if (!*slask)
						break;
					else
					{
						strupr(slask);
						i = 0;
						if (isdigit(*slask))
						{
							while (isdigit(slask[i]))
								i++;
							strncpy(s2,slask,i);
							s2[i] = 0;
							while (slask[i] == ' ' || slask[i] == 9)
								i++;
						}
						else
							*s2 = 0;
						newln = new LINE;
						newln -> next = ln;
						if (*s2)
							newln -> line = atoi(s2);
						else
						{
							newln -> line = ln ? ln -> line : -1;
							if (ln)
								ln -> line = -1;
						}
						newln -> the_str = new char[strlen(slask + i) + 1];
						strcpy(newln -> the_str,slask + i);
						if (ln2)
							ln2 -> next = newln;
						else
							m_linebase = newln;
						ln2 = newln;
					}
				}
				break;
			case '.': // exit
			case 'q':
			case 'Q':
				quit++;
				break;

			default: // help
				if (*slask)
				{
					pprintf("Edit Help\n");
					pprintf(" i      insert line before current line\n");
					pprintf(" d      delete current line\n");
					pprintf(" <      move up\n");
					pprintf(" >      move down\n");
					pprintf("[enter] move\n");
					pprintf(" s/x/y  substitute x with y\n");
					pprintf(" . or Q exits\n");
				}
				else
				{
					if (dir < 0)
					{
						if (ln == m_linebase)
							pprintf("Already at top.\n");
						else
						{
							for (ln2 = m_linebase; ln2; ln2 = ln2 -> next)
								if (ln2 -> next == ln)
									break;
							ln = ln2;
						}
					}
					else
					if (dir > 0)
					{
						if (!ln)
							pprintf("Already at bottom.\n");
						else
							ln = ln -> next;
					}
				}
				break;
			}
		}
		break;
	case 8: // info
		getcwd(slask,200);
		ptr = strtok(slask,"/");
		*s2 = 0;
		while (ptr)
		{
			strcpy(s2,ptr);
			ptr = strtok(NULL,"/");
		}
		pprintf("Current disk: '%s'\n",s2);
		pprintf("Program name: '%s'\n",m_programname);
		break;
	case 9: // help
		pprintf("Online help:\n");
		pprintf(" LOAD <program>\n");
		pprintf(" SAVE [<program>]\n");
		pprintf(" RUN [<program>]\n");
		pprintf(" LIST        - list loaded program\n");
		pprintf(" EDIT [<line>]\n");
		pprintf(" NEW         - delete program in memory\n");
		pprintf(" TYPE <file> - read a file\n");
		pprintf(" DUMP <file> - hex dump a file\n");
		pprintf(" CATALOG     - lists files on current disk\n");
		pprintf(" DISKS       - show available disks\n");
		pprintf(" CD <disk>   - change disk\n");
		pprintf(" INFO        - show current disk and loaded program\n");
		pprintf(" HELP\n");
		pprintf(" QUIT\n");
		pprintf("\n");
		break;
	case 10: // disks
		if ((fil = popen("ls -F ..","r")) != NULL)
		{
			fgets(slask,200,fil);
			while (!feof(fil))
			{
				slask[strlen(slask) - 1] = 0;
				if (slask[strlen(slask) - 1] == '/')
				{
					slask[strlen(slask) - 1] = 0;
					pprintf("%s\n",slask);
				}
				fgets(slask,200,fil);
			}
			pclose(fil);
		}
		break;
	case 11: // cd
		if (!arg)
		{
			pprintf("CD where?\n");
			break;
		}
		ptr = strstr(arg,"..");
		if (ptr)
			*ptr = 0;
		ptr = strstr(arg,"/");
		if (ptr)
			*ptr = 0;
		sprintf(slask,"../%s",arg);
		if (chdir(slask) == -1)
			pprintf("Failed.\n");
		else
			pprintf("Ok.\n");
		break;
	case 12: // type
		if (!arg)
		{
			pprintf("TYPE what?\n");
			break;
		}
		verify_filename( arg );
		fil = fopen(arg,"rb");
		if (!fil)
		{
			strupr(arg);
			fil = fopen(arg,"rb");
		}
		if (fil)
		{
			fread(&c,1,1,fil);
			i = 0;
			while (!feof(fil))
			{
				c &= 127;
				if (c == 0x0d)
				{
					pprintf("\n");
					x++;
				} else
				{
					pprintf("%c",isprint(c) ? c : '.');
					x = 0;
				}
				fread(&c,1,1,fil);
				if (x)
				{
					if (m_pclParserIO -> m_more && i++ > 20 && !feof(fil))
					{
						pprintf("[More]");
						inputstring(slask,200);
						if (*slask == 'q' || *slask == 'Q')
							break;
						i = 0;
					}
				}
			}
			fclose(fil);
			if (!x)
				pprintf("\n");
		}
		else
			pprintf("Couldn't open '%s'...\n",arg);
		break;
	case 13: // dump
		if (!arg)
		{
			pprintf("DUMP what?\n");
			break;
		}
		verify_filename( arg );
		fil = fopen(arg,"rb");
		if (!fil)
		{
			strupr(arg);
			fil = fopen(arg,"rb");
		}
		if (fil)
		{
			long addr = 0;

			x = 0;
			while (!feof(fil))
			{
				pprintf("%04lx %04lx ",addr / 65536L,addr % 65536L);
				*slask = 0;
				for (i = 0; i < 16; i++)
				{
					fread(&c,1,1,fil);
					pprintf(" %02x", (unsigned char)c);
					if (isprint(c & 0x7f))
						sprintf(slask + strlen(slask),"%c",c & 0x7f);
					else
						strcat(slask,".");
					if (i == 7)
					{
						pprintf(" ");
						strcat(slask," ");
					}
				}
				pprintf("  %s\n",slask);
				if (m_pclParserIO -> m_more && x++ > 20 && !feof(fil))
				{
					pprintf("[More]");
					inputstring(slask,200);
					if (*slask == 'q' || *slask == 'Q')
						break;
					x = 0;
				}
				addr += 16;
			}
			fclose(fil);
		}
		else
			pprintf("Couldn't open '%s'...\n",arg);
		break;

	default:
		if (!this -> editcmd( in ))
		{
			strcpy(m_the_str, in);
			m_the_ptr = 0;
			strupr(m_the_str);		// all uppercase
			m_current_line = m_linebase;	// %! bug
			m_running = 1;
			if (yyparse( this ))
				fprintf(stderr," *** error\n");
		}
		break;
	}
	flush_obuf();
}

int Parser::editcmd(char *in)
{
	LINE *ln = m_current_line;

	return 0;

	if (*in >= 'a' && *in <= 'z')
		*in -= 32;
	if (isdigit(*in))
	{

// #   g till rad nummer #

	}
	else
	switch (*in)
	{
	case 'E': // E   g till slutet av texten
		break;
	case 'N': // B   g till brjan av texten
		break;
	case 'I': // I   skjut in rader fre aktuell rad, avsluta med tom rad
		break;
	case 'D': // D   ta bort aktuell rad
		break;

// QU  avsluta utan att spara
// EX  avsluta och spara
// EC  avsluta, spara, och kompilera

	case 'S': // S/xx/yy    byt ut xx mot yy p aktuell rad
		break;
	case '+': // // +x  g fram x rader
		break;
	case '-': // -x  g bak x rader
		break;
	case 'L': // L   lista hela texten
// L#  lista texten frn rad #
		break;

// >   skjut in 2 mellanslag
// <   ta bort 2 mellanslag

	case 'A': // A   upprepa fregende kommando
		break;

	default:
		return 0;
	}
	return 1;
}
